import { world, system, EffectTypes, DimensionTypes, ItemStack } from "@minecraft/server"

world.afterEvents.playerJoin.subscribe(({ playerId }) => {
    system.runTimeout(() => {
        for (const player of world.getPlayers()) {
            if (player.id == playerId) {
                let intervalo = system.runInterval(() => {
                    let { x, y, z } = player.getVelocity()
                    if (x != 0 || y != 0 && z != 0) {
                        SendMessageTo(player)
                        system.clearRun(intervalo)
                    }
                }, 5)
            }
        }
    }, 500)
})

world.afterEvents.worldInitialize.subscribe(() => {
    SendMessageTo(world)
})


function SendMessageTo(reciber) {
    system.runTimeout(() => {
        reciber.sendMessage("XP Tome Addon (1.21.50) Active")
    }, 1)
}

const TOME_TIERS = {
    "geo:xp_tome_tier5": 1395,
    "geo:xp_tome_tier4": 2920,
    "geo:xp_tome_tier3": 5345,
    "geo:xp_tome_tier2": 8670,
    "geo:xp_tome_tier1": 30970,
};

world.beforeEvents.itemUse.subscribe(({ source, itemStack }) => {
    if (!TOME_TIERS[itemStack.typeId]) return;

    system.run(() => {
        let isSneaking = source.isSneaking;
        let totalXP = source.getTotalXp();
        let inventory = source.getComponent("minecraft:inventory").container;
        let selectedSlot = source.selectedSlotIndex;
        let tomeType = itemStack.typeId;
        let maxDurability = TOME_TIERS[tomeType];
        let newTome = new ItemStack(tomeType, 1);
        newTome.setLore([`XP: ${source.getTotalXp()} / ${maxDurability}`]);
        let oldDurability = itemStack.getComponent("durability").damage;
        let newDurability = newTome.getComponent("durability");

        if (isSneaking) {
            handleSneaking(source, totalXP, inventory, selectedSlot, newTome, oldDurability, newDurability, maxDurability);
        } else {
            handleNotSneaking(source, totalXP, inventory, selectedSlot, newTome, oldDurability, newDurability, maxDurability);
        }
    });
});

function handleSneaking(source, totalXP, inventory, selectedSlot, newTome, oldDurability, newDurability, maxDurability) {
    if (totalXP < maxDurability && totalXP > 0 && oldDurability !== 0) {
        let restXP = 0;
        let remainingXP = maxDurability - oldDurability;
        let newDamage = maxDurability - (totalXP + remainingXP);

        if (newDamage <= 0) {
            newDurability.damage = 0;
            restXP = Math.abs(newDamage);
        } else {
            newDurability.damage = newDamage;
        }

        newTome.setLore([`XP: ${totalXP} / ${maxDurability}`]);
        inventory.setItem(selectedSlot, newTome);
        setXP(source, restXP);
    } else if (totalXP >= maxDurability && oldDurability !== 0) {
        newDurability.damage = 0;
        let xpLasted = totalXP - maxDurability;

        newTome.setLore([`XP: ${totalXP} / ${maxDurability}`]);
        inventory.setItem(selectedSlot, newTome);
        setXP(source, xpLasted);
    }
}

function handleNotSneaking(source, totalXP, inventory, selectedSlot, newTome, oldDurability, newDurability, maxDurability) {
    if (oldDurability === maxDurability) return;

    let xpGiven = totalXP + (maxDurability - oldDurability);
    newDurability.damage = maxDurability;

    newTome.setLore([`XP: ${totalXP} / ${maxDurability}`]);
    inventory.setItem(selectedSlot, newTome);
    setXP(source, xpGiven);
}

function setXP(player, quantity) {
    player.runCommand(`xp -10000L @s`);
    player.runCommand(`xp ${quantity} @s`);
}

system.runInterval(() => {
    for (const player of world.getPlayers()) {
        let inv = player.getComponent("minecraft:inventory");
        let con = inv.container;
        for (let i = 0; i < con.size; i++) {
            let item = con.getItem(i);
            if (item && item.typeId.endsWith("_dummy")) {
                let baseType = item.typeId.replace("_dummy", "");
                if (TOME_TIERS[baseType]) {
                    let xpTome = new ItemStack(baseType, 1);
                    let durability = xpTome.getComponent("durability");
                    durability.damage = TOME_TIERS[baseType];
                    xpTome.setLore([`XP: 0 / ${TOME_TIERS[baseType]}`]);
                    con.setItem(i, xpTome);
                }
            }
        }
    }
}, 5);
